<?php

declare(strict_types=1);

namespace App\Entity\DataChangeLog;

use App\Entity\Device\Device;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'data_change_log')]
#[ORM\Entity]
class DataChangeLog
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var DataChangeSource
     */
    #[ORM\ManyToOne(targetEntity: DataChangeSource::class, inversedBy: 'sources')]
    #[ORM\JoinColumn(name: 'source')]
    public DataChangeSource $source;

    /**
     * @var DataAtom
     */
    #[ORM\ManyToOne(targetEntity: DataAtom::class, inversedBy: 'atoms')]
    #[ORM\JoinColumn(name: 'atom')]
    public DataAtom $atom;

    /**
     * @var Device|null
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'dataChangeLogs')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public ?Device $device = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $extraId = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::TEXT, nullable: true)]
    public ?string $extraTxt = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::TEXT, nullable: true)]
    public ?string $valueTxt = null;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'change_timestamp', type: Types::DATETIME_MUTABLE, options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $time;

    /**
     * EventLog constructor.
     */
    public function __construct(){

        $this->time = new \DateTime();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return DataChangeSource
     */
    public function getSource(): DataChangeSource {

        return $this->source;

    }

    /**
     * @return void
     */
    public function setSource(DataChangeSource $source): void {

        $this->source = $source;

    }

    /**
     * @return DataAtom|null
     */
    public function getAtom(): ?DataAtom {

        return $this->atom;

    }

    /**
     * @param DataAtom|null $atom
     * @return void
     */
    public function setAtom(?DataAtom $atom): void {

        $this->atom = $atom;

    }

    /**
     * @return Device|null
     */
    public function getDevice(): ?Device {

        return $this->device;

    }

    /**
     * @param Device|null $device
     * @return void
     */
    public function setDevice(?Device $device): void {

        $this->device = $device;

    }

    /**
     * @return string|null
     */
    public function getValueTxt(): ?string {

        return $this->valueTxt;

    }

    /**
     * @param string|null $value
     * @return void
     */
    public function setValueTxt(?string $value): void {

        $this->valueTxt = $value;

    }

    /**
     * @return int|null
     */
    public function getExtraId(): ?int {

        return $this->extraId;

    }

    /**
     * @param int|null $extraId
     * @return void
     */
    public function setExtraId(?int $extraId): void {

        $this->extraId = $extraId;

    }

}