<?php

declare(strict_types=1);

namespace App\Entity\EventLog;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'log_event_type')]
#[ORM\Entity]
class EventType
{
	//UI Specific Event types
    final public const UI_USER_LOGIN_EVENT_TYPE_NAME = 'User login';
    final public const UI_CRITICAL_ERROR_WEBUI_EVENT_TYPE_NAME = 'Critical error (WebUI)';
    final public const UI_RESTART_REQUESTED_EVENT_TYPE_NAME = 'Restart requested';
    final public const UI_DEVICE_CFG_USER_UPDATE_EVENT_TYPE_NAME = 'Device CFG user-update';
    final public const UI_NEW_FW_VERSION_REQUESTED_EVENT_TYPE_NAME = 'New FW version requested';
    final public const UI_ALERT_CONFIG_UPDATE_EVENT_TYPE_NAME = 'Alert config update';
    final public const UI_GENERAL_NOTICE_EVENT_TYPE_NAME = 'General notice';
    final public const UI_LICENSE_UPLOADED_EVENT_TYPE_NAME = 'License uploaded';
    final public const UI_UPGRADE_PKG_UPLOADED_EVENT_TYPE_NAME = 'Upgrade pkg uploaded';
    final public const UI_EVENTSYNC_UI_EVENT_TYPE_NAME = 'Eventsync (UI)';
    final public const UI_PROFILE_UPDATE_EVENT_TYPE_NAME = 'Profile update';
    final public const UI_TUNNEL_CFG_UPDATE_EVENT_TYPE_NAME = 'Tunnel CFG update';
    final public const UI_DELETION_USER_REQUEST_EVENT_TYPE_NAME = 'FW deletion user request';
	final public const UI_FW_FILE_UPLOADED_EVENT_TYPE_NAME = 'FW file uploaded';
    final public const UI_MONITORING_GROUP_UPDATE_EVENT_TYPE_NAME = 'Monitoring group update';
    final public const UI_GROUP_UPDATE_EVENT_TYPE_NAME = 'CFG group update';
    final public const UI_BUTTON_EVENT_TYPE_NAME = 'Button event';

	final public const SYSTEM_SERVICE_START_BUTTON_ID = 1;
	final public const SYSTEM_SERVICE_RESTART_BUTTON_ID = 2;
	final public const SNMP_SERVICE_START_BUTTON_ID = 3;
	final public const SNMP_SERVICE_STOP_BUTTON_ID = 4;
	final public const SNMP_SERVICE_RESTART_BUTTON_ID = 5;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 32, unique: true, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: EventLog::class, mappedBy: 'eventType', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $events;

    /**
     * EventType constructor
     */
    public function __construct()
    {

        $this->events = new ArrayCollection();
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string
    {

        return $this->name;
    }
}
