<?php

declare(strict_types=1);

namespace App\Entity\Product;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'product_flags')]
#[ORM\Entity]
class ProductFlags
{
    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING)]
    #[ORM\Id]
    private readonly string $id;

    /**
     * @var int
     */
    #[ORM\Column(type: Types::INTEGER, nullable: false)]
    public int $version;

    /**
     * @var string
     */
    #[ORM\Column(name: 'description', type: Types::TEXT, nullable: true, options: ['default' => null])]
    public ?string $description = null;

    /**
     * @return string
     */
    public function getId(): string
    {

        return $this->id;

    }

    /**
     * @return int
     */
    public function getVersion(): int{

        return $this->version;

    }

    public function setVersion(int $version): void
    {

        $this->version = $version;

    }

    /**
     * @return string
     */
    public function getDescription(): ?string {

        return $this->description;

    }

}