<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CustomScriptType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $customScript = $options['data']['customScript'];
        $deviceTypes = $options['data']['deviceTypes'];
        $agentProfiles = $options['data']['agentProfiles'];

        $devTypeChoices = [];
        $agentProfileChoices = [];
        $devTypeSelectedData = [];
        $agentProfileSelectedData = [];

        foreach ($deviceTypes as $deviceType) {
            $devTypeChoices[$deviceType->getName()] = $deviceType->getId();
        }

        foreach ($agentProfiles as $agentProfile) {
            $agentProfileChoices[$agentProfile->getProfileName()] = $agentProfile->getId();
        }

        foreach ($customScript->getDevTypeMaps() as $devTypeMap){
            $devTypeSelectedData[] = $devTypeMap->getDevType()->getId();
        }

        foreach ($customScript->getAgentProfileMap() as $agentProfileMap){
            $agentProfileSelectedData[] = $agentProfileMap->getAgentProfile()->getId();
        }

        $builder
            ->add('description', TextType::class, [
                'data' => $customScript->description ?? null,
                'block_prefix' => 'modal_body'])
            ->add('code', TextareaType::class, [
                'data' => $customScript->code ?? null,
                'block_prefix' => 'modal_body',
                'attr' => array('rows' => '20')
            ])
            ->add('deviceType', ChoiceType::class, [
                'required' => false,
                'choices' => $devTypeChoices,
                'data' => $devTypeSelectedData ?? null,
                'block_prefix' => 'modal_body',
                'multiple' => true,
                'expanded' => false,
            ])
            ->add('agentProfile', ChoiceType::class, [
                'required' => false,
                'choices' => $agentProfileChoices,
                'data' => $agentProfileSelectedData ?? null,
                'block_prefix' => 'modal_body',
                'multiple' => true,
                'expanded' => false,
            ])
            ->add('save', SubmitType::class, ['label' => 'Add Custom script',
                'block_prefix' => 'modal_footer'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {

        $resolver->setDefaults([
           // 'data_class' => OsVersion::class,
        ]);

    }

}