<?php

namespace App\Form\Device;

use App\Entity\Device\Device;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class DeviceAuthProfileType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $authProfiles = $options['data']['authProfiles'];
        /** @var Device $device */
        $device = $options['data']['device'];

        $choices = ['- No Auth Profile -' => '-'];

        foreach ($authProfiles as $profile) {
            $choices[$profile->getProfileName()] = $profile->getId();
        }

        if ($authProfiles) {
            $builder
                ->add('auth_profile', ChoiceType::class, [
                    'choices' => $choices,
                    'data' => (!is_null($device->getAuthProfile())) ? $device->getAuthProfile()->getId() : null,
                    'attr' => ['class' => 'form-control-sm'],
                ])
                ->add('save', SubmitType::class, [
                    'label' => 'Set',
					'icon' => 'fas fa-bars-progress',
                    'attr' => ['class' => 'btn-primary btn-sm'],
                    'block_prefix' => 'modal_footer'
                ])
            ;
        }
    }
}
