<?php

namespace App\Form\Device;

use App\Entity\Device\Device;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class DeviceHostnameType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        /** @var \App\Entity\Device\Device $device */
        $device = $options['data']['device'];

        $builder
            ->add('hostname', TextType::class, array(
                //'data_class' => 'App\Entity\OsVersion',
                'data' =>
                    (!is_null($device->getHostnameDesired())) ? $device->getHostnameDesired() : $device->getHostname(),

            ))
            ->add('save', SubmitType::class, ['label' => 'Set hostname',
                'block_prefix' => 'modal_footer'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {

        $resolver->setDefaults([
           // 'data_class' => OsVersion::class,
        ]);
    }
}
