<?php

declare(strict_types=1);

namespace App\Form\Extension;

use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;
class IconButtonTypeExtension extends AbstractTypeExtension
{
	public static function getExtendedTypes(): iterable
	{
		return [ButtonType::class, SubmitType::class];
	}

    public function configureOptions(OptionsResolver $resolver): void
	{
        $resolver->setDefined(['icon', 'icon_position']);
		$resolver->setDefaults([
			'icon' => null,
			'icon_position' => 'before', // Default position
		]);

		$resolver->setAllowedTypes('icon', ['null', 'string']);
		$resolver->setAllowedValues('icon_position', ['before', 'after']);
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
	{
        if (array_key_exists('icon', $options)) {
            $icon = $options['icon'];

            if (!array_key_exists('icon_position', $options) || !in_array($options['icon_position'], ['after', 'before'], true)) {
                throw new \InvalidArgumentException('`icon_position` property can have only 0, 1, `after` or `before` value.');
            }

            $iconPosition = $options['icon_position'];

        } else {
            $icon = null;
            $iconPosition = null;
        }

        $view->vars['icon'] = $icon;
        $view->vars['icon_position'] = $iconPosition;

    }

}
