<?php

declare(strict_types=1);

namespace App\Service\Api;

use Symfony\Component\String\Exception\RuntimeException;
use Symfony\Contracts\HttpClient\Exception\ClientExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\RedirectionExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\ServerExceptionInterface;
use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;

final class Device extends ApiService
{

    private const URL_API_DEVICE_REBOOT = '/g/reboo';
    private const API_PARAM_DEVICE_ID = 'devid';

    /**
     * @param array $deviceIds
     * @return string
     * @throws ClientExceptionInterface
     * @throws RedirectionExceptionInterface
     * @throws ServerExceptionInterface
     * @throws TransportExceptionInterface
     * @throws \JsonException
     */
    public function reboot(array $deviceIds): string
    {

        $urlParams = self::API_PARAM_DEVICE_ID . '=' . implode(',', $deviceIds);

        $result = $this->getApiCall($this->baseUrl . self::URL_API_DEVICE_REBOOT . '?' . $urlParams, true);

        if ($result && $result->operation_result->Code === 0) {
            return $result->operation_result->Description;
        }

        throw new RuntimeException($result->operation_result->Description, $result->operation_result->Code);

    }

}
