<?php

namespace App\Service;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use Doctrine\ORM\QueryBuilder;

class ExportService
{
    private array $existedAliases = [];

    /**
     * @param DatatableService $datatableService
     * @param DatatableResponse $datatableResponse
     */
    public function __construct(
        private readonly DatatableService $datatableService,
        private readonly DatatableResponse $datatableResponse,
    ) {
    }

    /**
     * @return array
     * @throws \Exception
     */
    public function getDataExportForDeviceDataTable(): array
    {

        $datatable = $this->datatableService->getDeviceDatatable();
        $this->datatableResponse->setDatatable($datatable);

        $datatableQueryBuilder = new DatatableQueryBuilder([], $datatable);
        $this->datatableResponse->setDatatableQueryBuilder($datatableQueryBuilder);

        $columnNames = $datatable->getColumnBuilder()->getColumnNames();
        $columnData = $datatable->getColumnBuilder()->getColumns();

        $aliases = [];
        $qb = $datatableQueryBuilder->getQb();

        foreach ($columnNames as $name => $key) {

            if($name === ''){
                //skip empty columns like actions
                continue;
            }

            $nameParts = explode('.', $name);

            if(count($nameParts) === 1) {

                //process simple column values and custom dqls
                if ($columnData[$key]->isCustomDql()) {
                    //dump($columnData[$key]);
                    $columnAlias = str_replace('.', '_', $name);

                    $dql = $columnData[$key]->getDql();
                    $selectDql = preg_replace('/\{([\w]+)\}/', '$1', $dql);

                    $qb->addSelect($selectDql . ' ' . $columnAlias );
                    //die();
                } else {
                    $qb->addSelect('vdevice.' . $name . ' AS ' . $columnData[$key]->getData());
                }

            }else{

                //Process joined values
                $this->addJoinedDataTableData($nameParts, $qb, $columnData[$key]);
            }
        }

        $qb->andWhere('vdevice.deleted = :deleted');
        $qb->setParameter('deleted', '0');

        //dump($datatableQueryBuilder->getQb()->getDQL());
        //dump($datatableQueryBuilder->getQb()->getQuery()->getSQL());
        return $datatableQueryBuilder->getQb()->getQuery()->getArrayResult();

    }

    /**
     * @param array $nameParts
     * @param QueryBuilder $qb
     * @param $columnData
     * @param array $aliases
     * @return void
     */
    private function addJoinedDataTableData(array $nameParts, QueryBuilder $qb, $columnData): void
    {
        $alias = [];

        foreach ($nameParts as $keyPart => $namePart) {

            if ($keyPart == count($nameParts) - 1) {
                $qb->addSelect($alias[$keyPart - 1] . '.' . $namePart . ' AS ' . $columnData->getName());
            } else {
                if (empty($alias)) {
                    $alias[$keyPart] = '_a' . $namePart;
                    if (!in_array($alias[$keyPart], $this->existedAliases)) {
                        $this->existedAliases[] = '_a' . $namePart;
                        $qb->leftjoin('vdevice.' . $namePart, $alias[$keyPart]);
                    }

                } else {
                    $alias[$keyPart] = '_a' . $namePart;
                    if (!in_array($alias[$keyPart], $this->existedAliases)) {
                        $this->existedAliases[] = '_a' . $namePart;
                        $qb->leftjoin($alias[$keyPart - 1] . '.' . $namePart, $alias[$keyPart]);
                    }
                }
            }
        }
    }

}
