<script setup>
    import ActionTypeOptions from "./options/action.md";
    import TurboPrefetchingSection from "./../../../shared/turbo-prefetching.md";
</script>

# LinkActionType

The [`LinkActionType`](https://github.com/Kreyu/data-table-bundle/blob/main/src/Action/Type/LinkActionType.php) represents an action rendered as a simple link.

## Prefetching

<TurboPrefetchingSection>

```php
use Kreyu\Bundle\DataTableBundle\Action\Type\LinkActionType;

$builder->addRowAction('show', LinkActionType::class, [
    'attr' => [
        // note that this "false" should be string, not a boolean
        'data-turbo-prefetch' => 'false',
    ],
]);
```

</TurboPrefetchingSection>

## Options

### `href`

- **type**: `string` or `\Closure` (if using as a row action)
- **default**: `'#'`

A value used as an action link [href attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a#attr-href).

```php
use Kreyu\Bundle\DataTableBundle\Action\Type\LinkActionType;

$builder
    ->addAction('back', LinkActionType::class, [
        'href' => $this->urlGenerator->generate('category_index'),
    ])
;
```

When using the `LinkActionType` as a [row action](../../../docs/components/actions.md), you can provide a closure
that will receive the row data as an argument and should return a string.

```php
use Kreyu\Bundle\DataTableBundle\Action\Type\LinkActionType;

$builder
    ->addAction('back', LinkActionType::class, [
        'href' => function (Category $category) {
            return $this->urlGenerator->generate('category_index', [
                'id' => $category->getId(),        
            ]);
        },
    ])
;
```

### `target`

- **type**: `string` or `\Closure` (if using as a row action)
- **default**: `'_self'`

Sets the value that will be used as an anchor [target attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a#attr-target).

```php
use Kreyu\Bundle\DataTableBundle\Action\Type\LinkActionType;

$builder
    ->addAction('wiki', LinkActionType::class, [
        'target' => '_blank',
    ])
;
```

When using the `LinkActionType` as a [row action](../../../docs/components/actions.md), you can provide a closure
that will receive the row data as an argument and should return a string.

```php
use Kreyu\Bundle\DataTableBundle\Action\Type\LinkActionType;

$builder
    ->addRowAction('wiki', LinkActionType::class, [
        'target' => function (Configuration $configuration) {
            return $configuration->shouldOpenNewTab() ? '_blank' : '_self';
        },
    ])
;
```

## Inherited options

<ActionTypeOptions/>
