<?php

namespace App\Form\Device;

use App\Entity\Device\Device;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class DeviceAgentProfileType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $agentProfiles = $options['data']['agentProfiles'];
        /** @var \App\Entity\Device\Device $device */
        $device = $options['data']['device'];

        $choices = [];

        foreach ($agentProfiles as $profile) {
            $choices[$profile->getProfileName()] = $profile->getId();
        }

        if ($agentProfiles) {
            $builder
                ->add('agent_profile', ChoiceType::class, [
                    'choices' => $choices,
                    'data' =>
                        (!is_null($device->getAgentProfile())) ? $device->getAgentProfile()->getId() : null,
                    'attr' => ['class' => 'form-control-sm'],
                ])
                ->add('save', SubmitType::class, [
					'label' => 'Set',
					'icon' => 'fas fa-file-lines',
					//'icon_position' => 'before',
                    'attr' => ['class' => 'btn-primary btn-sm'],
                    'block_prefix' => 'modal_footer'
                ])
            ;
        }
    }
}
