<?php

namespace App\Repository;

use App\Entity\Alert\Alert;
use App\Entity\Device\FwFileName;
use App\Entity\EventLog\EventLog;
use App\Entity\EventLog\EventSource;
use App\Entity\EventLog\EventType;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * @method EventLog|null find($id, $lockMode = null, $lockVersion = null)
 * @method EventLog|null findOneBy(array $criteria, array $orderBy = null)
 * @method EventLog[]    findAll()
 * @method EventLog[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class EventLogRepository extends ServiceEntityRepository
{
    public const ACTION_CREATE = 'created';
    public const ACTION_UPDATE = 'updated';

    public const MESSAGE_ALERT_ENTITY = 'Alert was %s.';

    private EventTypeRepository $eventTypeRepository;
    private EventSourceRepository $eventSourceRepository;

    public function __construct(
        ManagerRegistry $registry,
        EventTypeRepository $eventTypeRepository,
        EventSourceRepository $eventSourceRepository
    ) {

        parent::__construct($registry, EventLog::class);

        $this->eventTypeRepository = $eventTypeRepository;
        $this->eventSourceRepository = $eventSourceRepository;
    }

	/**
	 * @param string $entityName
	 * @param UserInterface $user
	 * @param int|null $entityId
	 * @param string|null $action
	 * @param string|null $message
	 * @param int|null $extraId
	 * @return EventLog
	 */
    public function addEventLog(
        string $entityName,
		UserInterface $user,
		?int $entityId = null,
		?string $message = null,
		?string $action = null,
        ?int $extraId = null,
    ): EventLog {

        if (!$message) {
            if ($entityName === Alert::class) {
                $eventTypeName = EventType::UI_ALERT_CONFIG_UPDATE_EVENT_TYPE_NAME;
                $message = sprintf(self::MESSAGE_ALERT_ENTITY, $action);
            //} else {
             //   throw new \RuntimeException('Not valid entity type given.');
            }
        }

        if ($entityName === FwFileName::class) {
            $eventTypeName = EventType::UI_FW_FILE_UPLOADED_EVENT_TYPE_NAME;
        }

		if(empty($eventTypeName)){
			$eventTypeName = $entityName;
		}

        $eventType = $this->eventTypeRepository->findOneBy(['name' => $eventTypeName]);
		if(!$eventType){
			throw new \RuntimeException('Invalid evenTypeName given: ' . $eventTypeName);
		}
        $eventSource = $this->eventSourceRepository->findOneBy(['id' => EventSource::APP_WEBUI]);
        $eventLog = new EventLog();
        $eventLog->setEventType($eventType);
        $eventLog->setUser($user);
        if($entityId){
			$eventLog->setValue($entityId);
		}
        $eventLog->setSource($eventSource);
        $eventLog->setExtraId($extraId);
        $eventLog->setMsg($message);

        return $eventLog;
    }

    public function persist(EventLog $eventLog): void
    {
        $this->getEntityManager()->persist($eventLog);
        $this->getEntityManager()->flush();
    }

}
