<?php

namespace App\Repository;

use App\Entity\Tool\SimCard;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method SimCard|null find($id, $lockMode = null, $lockVersion = null)
 * @method SimCard|null findOneBy(array $criteria, array $orderBy = null)
 * @method SimCard[]    findAll()
 * @method SimCard[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class SimCardRepository extends ServiceEntityRepository
{

    /**
     * @param ManagerRegistry $registry
     */
    public function __construct(ManagerRegistry $registry){

        parent::__construct($registry, SimCard::class);

    }

    public function findAllActiveSimCards(): array {

		$em = $this->getEntityManager();
        $qb = $em->createQueryBuilder();

        return $this->createQueryBuilder('sc')
            ->where($qb->expr()->isNotNull('sc.msisdn'))
            ->andWhere($qb->expr()->orX(
                $qb->expr()->isNotNull('sc.deviceUser'),
                $qb->expr()->isNotNull('sc.deviceLastSeen')
            ))
            ->getQuery()->getResult();

    }

}
