<?php

declare(strict_types=1);

namespace App\Entity\Device;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_models')]
#[ORM\Entity]
class DeviceModel {

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 128, nullable: true)]
    public ?string $model = null;

	/**
	 * @var Collection
	 */
	#[ORM\OneToMany(targetEntity: Device::class, mappedBy: 'model', cascade: ['persist'])]
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'model')]
	public Collection $devices;

	public function __construct(){

		$this->devices = new ArrayCollection();

	}

    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->id;
    }

	/**
	 * @return string|null
	 */
	public function getModel(): ?string
	{
		return $this->model;
	}

	/**
	 * @return Collection
	 */
	public function getDevices(): Collection
	{
		return $this->devices;
	}
}
