<?php

namespace App\Form\Device;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class DeviceConfigProfileType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
	{

        $device = $options['data']['device'];
        $configProfiles = $options['data']['configProfiles'];
		$isAssigned = $options['data']['isAssigned'];

        $choices = [];
        $choicesAttr = [];

        foreach ($configProfiles as $item) {

            $choices[$item->getId() . ' ' . $item->getName()] = $item->getId() ;
            $choicesAttr[$item->getId()] = ['data-description' => $item->getName()];

        }

        $builder
            ->add('config_profile', ChoiceType::class ,array(
                'choices' => $choices,
                'choice_attr' => $choicesAttr,
                'placeholder' => '- No Config profile -',
                'data' => ($device->configProfile) ? $device->configProfile->getId() : null,
				'attr' => ['class' => 'form-control-sm'],

            ))
            ->add('save', SubmitType::class, [
				'label' => 'Set ',
				'icon' => 'fas fa-list-check',
                'block_prefix' => 'modal_footer',
				'attr' => ['class' => 'btn-primary btn-sm'],
			]);

        if($isAssigned){

            $builder->add('unset', SubmitType::class, [
				'label' => 'Unset',
				'icon' => 'fas fa-remove',
				'attr' => ['class' => 'btn-secondary btn-sm'],
			]);

        }

    }

}