<?php

namespace App\Service;

use Symfony\Contracts\Translation\TranslatorInterface;

readonly class TranslationService
{

    public function __construct(
       private TranslatorInterface $translator
    ) {
    }

	public function getTranslatedStringsFromArray(array $arrayStrings): array
	{
		$locale = $this->translator->getLocale();
		$catalogue = $this->translator->getCatalogue($locale);

		foreach ($arrayStrings as $key => $label) {
			//check if translation exists
			if ($catalogue->has($key)) {
				$arrayStrings[$key] = $this->translator->trans($key);
			}
		}

		return $arrayStrings;
	}

}
