<?php

declare(strict_types=1);

namespace App\Controller\Admin;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\DataTable\DataChangeLogDatatable;
use App\Entity\DataChangeLog\DataAtom;
use Doctrine\Persistence\ManagerRegistry;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class DataChangeLogController extends BaseController
{
	/**
	 * @param Request $request
	 * @param ManagerRegistry $managerRegistry
	 * @param DatatableFactory $factory
	 * @param DatatableResponse $responseService
	 * @return Response
	 * @throws \Exception
	 */
    #[Route(path: '/admin/data-change-log', name: 'admin_data_change_log')]
    public function default(Request $request, ManagerRegistry $managerRegistry,
                            DatatableFactory $factory, DatatableResponse $responseService): Response{

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $atomTypes = $managerRegistry->getRepository(DataAtom::class)->findBy(['visible' => true]);

        $datatable = $factory->create(DataChangeLogDatatable::class);
        $datatable->buildDatatable(['atomTypes' => $atomTypes]);

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        return $this->render('dataChangeLog/dataChangeLog.html.twig', ['datatable' => $datatable, 'filter' => $this->filter]);

    }

}