<?php

declare(strict_types=1);

namespace App\Controller\Admin\Download;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Symfony\Component\Routing\Attribute\Route;

class AgentDownloadController extends Controller
{

    public function __construct(private readonly ParameterBagInterface $params)
    {
    }

	/**
	 * @param Request $request
	 * @param string $agentType
	 * @param string $agentFilename
	 * @return Response
	 */
    #[Route(path: 'download/agents/{agentType}/{agentFilename}', name: 'agents_download')]
    public function agents(Request $request, string $agentType, string $agentFilename): Response {

        $advantechAgentPath = $this->params->get('app.advantechAgentPath');

        $file = $advantechAgentPath . DIRECTORY_SEPARATOR . $agentType . DIRECTORY_SEPARATOR . $agentFilename;

        $response = new BinaryFileResponse($file);
        $response->setContentDisposition(
            ResponseHeaderBag::DISPOSITION_ATTACHMENT,
            $agentFilename
        );

        return $response;

    }

}