<?php

declare(strict_types=1);

namespace App\Controller\Admin;

use App\Service\ConfigurationService;
use Exception;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HelpController extends Controller
{

	/**
	 * @param Request $request
	 * @param $page
	 * @param ConfigurationService $configurationService
	 * @return Response
	 * @throws Exception
	 */
    #[Route(path: 'admin/help/{page}', name: 'admin_help')]
    public function help(Request $request, $page, ConfigurationService $configurationService): Response
	{

        $isFirstRun = null;

        if($page === 'welcome'){

            $isFirstRun = $configurationService->isFirstRun();
            $configurationService->updateIsFirstRun(false);

        }

        return $this->render('help/'. $page .'.html.twig', ['isFirstRun' => $isFirstRun]);

    }

}