<?php

namespace App\DataTable\Type;

use App\DataTable\Request\CustomRequestHandler;
use Kreyu\Bundle\DataTableBundle\Action\Type\ButtonActionType;
use Kreyu\Bundle\DataTableBundle\Column\Type\NumberColumnType;
use Kreyu\Bundle\DataTableBundle\Column\Type\TextColumnType;
use Kreyu\Bundle\DataTableBundle\Filter\FilterData;
use Kreyu\Bundle\DataTableBundle\Filter\Type\CallbackFilterType;
use Kreyu\Bundle\DataTableBundle\Query\ArrayProxyQuery;
use Kreyu\Bundle\DataTableBundle\Type\AbstractDataTableType;
use Kreyu\Bundle\DataTableBundle\DataTableBuilderInterface;
use Sg\DatatablesBundle\Datatable\Filter\FilterInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\RouterInterface;

class FwVersionDatatableType extends AbstractDataTableType
{

    public function __construct(
        private CustomRequestHandler $requestHandler, private readonly RouterInterface $router,
    ) {
    }

    public function buildDataTable(DataTableBuilderInterface $builder, array $options): void
    {
        $builder
            //->addColumn('id', NumberColumnType::class)
            ->addColumn('name', TextColumnType::class, ['sort' => true])
            ->addColumn('size', NumberColumnType::class, ['sort' => true])
            ->addColumn('created', TextColumnType::class, ['sort' => true]);

        $builder
            //->addFilter('id', NumericFilterType::class)
            //->addFilter('name', StringFilterType::class);
            ->addFilter('name', CallbackFilterType::class, [
                'callback' => function (ArrayProxyQuery $query, FilterData $data, FilterInterface $filter): void {
                    // ...
                    //dump($query, $data, $filter);
                    //die();
                },

            ]);

        $builder
            ->addAction('upload new Firmware', ButtonActionType::class, [
                'href' => $this->router->generate('admin_firmware_upload', ['fwId' => $options['fwId']]),
            ]);
            //->addRowAction('update', ButtonActionType::class)
            //->addBatchAction('delete', ButtonActionType::class);

        /*$builder
            ->addExporter('csv', CsvExporterType::class)
            ->addExporter('xlsx', XlsxExporterType::class);*/

        /*$builder->setSearchHandler(function (ArrayProxyQuery $query, string $search) {
            //dump($query, $search);
            //dump($query->getResult());
            //die();
        });*/

        $builder->setAutoAddingSearchFilter(false);

    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            //'request_handler' => $this->requestHandler,
            'fwId' => null
        ]);
    }

}