#!/bin/bash

MYID="User roles afterupdate fix script"
BASEDEFS="base_defs"
FUNCS="deploy_funcs.sh"
MYSQOPT=${MYSQOPT:-}
export MYSQOPT

select_users='SELECT id, email, roles FROM user;'

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR/$BASEDEFS" || { echo "$MYID: Fatal: Definition file ($DIR/$BASEDEFS) not found." >&2; exit 1; }
. "$DIR/$FUNCS" || { echo "$MYID: Fatal: Deploy functions ($DIR/$FUNCS) not found." >&2; exit 1; }
read_defs >/dev/null|| { echo "$MYID: Fatal: Cannot run read_defs()." >&2; exit 1; }
validate_deploy_commands || { echo "$MYID: Fatal: Cannot find mysql." >&2;exit 1; }

if [[ -z "$MYSQOPT" && -n "$DBPASS" ]] ; then
	MYSQOPT="-p$DBPASS"
fi

echo
echo -e "\t$MYID"
echo
echo "This script fixes user roles after update from older Dwarfguard version to version 2.x"
echo "Interrupt with CTRL-C now unless you know exactly what you are doing."
read

mapfile results < <( mysql "$DWARFG_DBN" $MYSQOPT -N --batch -e "$select_users" )

for numrow in ${!results[@]}; do
	row=( ${results[$numrow]} )
	echo " ---> Processing row: ${row[@]}"
	if [ ${#row[@]} -eq 3 ] ; then
		id="${row[0]}"
		email="${row[1]}"
		role="${row[2]}"
		case "$role" in
			ROLE_ADMIN|ROLE_SUPER_ADMIN)
				echo " ---> User role OK"
				;;
			*)
				if echo $role|grep ':'>/dev/null; then
					if echo $role|grep ROLE_SUPER_ADMIN >/dev/null; then
						if mysql "$DWARFG_DBN" -e "UPDATE user SET roles='ROLE_SUPER_ADMIN' WHERE id=$id" ; then
							echo " ===> Fixed user id/email: $id/$email to ROLE_SUPER_ADMIN"
						else
							echo " !!!!!!! ERROR !!!!!!"
							echo " Failed to fix user id/email: $id/$email role. Set it manually to ROLE_SUPER_ADMIN"
						fi
					elif echo $role|grep ROLE_ADMIN >/dev/null; then
						if mysql "$DWARFG_DBN" -e "UPDATE user SET roles='ROLE_ADMIN' WHERE id=$id" ; then
							echo " ===> Fixed user id/email: $id/$email to ROLE_ADMIN"
						else
							echo " !!!!!!! ERROR !!!!!!"
							echo " Failed to fix user id/email: $id/$email role. Set it manually to ROLE_ADMIN"
						fi
					else
						echo " !!!!!!! ERROR !!!!!!"
						echo " User id/email: $id/$email role not recognized, fix manually (assign either "ROLE_SUPER_ADMIN" or "ROLE_ADMIN" text in the user table under the role column."
					fi
				else
					echo " !!!!!!! ERROR !!!!!!"
					echo " User id/email: $id/$email role ($role) cannot be determined, fix manually (assign either "ROLE_SUPER_ADMIN" or "ROLE_ADMIN" text in the user table under the role column."
				fi
				;;
		esac
	else
		echo "Invalid number of raw columns - ${#row[@]} instead of 3. Check and fix manually."
	fi
done

