<?php

namespace App\Controller\Admin\UserProfile;

use App\Form\UserChangePasswordType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class UserProfileController  extends Controller
{

    /**
     * @return Response
     */
    #[Route(path: '/admin/user-profile', name: 'admin_user_profile')]
    public function default(Request $request, UserInterface $user, UserPasswordHasherInterface $passwordHasher,
                            ManagerRegistry $managerRegistry): Response
	{

        $changePasswordForm = $this->createForm(UserChangePasswordType::class);

        $changePasswordForm->handleRequest($request);

        if ($changePasswordForm->isSubmitted() && $changePasswordForm->isValid()) {

            $oldPassword = $changePasswordForm->get('current')->getData();
            $newPassword = $changePasswordForm->get('password')->getData();

            if (!$passwordHasher->isPasswordValid($user, $oldPassword)) {

                $this->addFlash(
                    'danger',
                    'Invalid current password given.'
                );

                return $this->redirectToRoute('admin_user_profile');

            }

            $password = $passwordHasher->hashPassword($user, $newPassword);
            $user->setPassword($password)
                ->setConfirmationToken(null)
                ->setPasswordRequestedAt(null);

            // Save User
            $managerRegistry->getManager()->persist($user);
            $managerRegistry->getManager()->flush();

            $this->addFlash(
                'success',
                'Password was successfully changed.'
            );

            return $this->redirectToRoute('admin_user_profile');

        }

        return $this->render("userProfile/userProfile.html.twig", [
            'user' => $user,
            'changePasswordForm' => $changePasswordForm->createView(),
        ]);

    }

}