<?php

declare(strict_types=1);

namespace App\Entity\Alert;

use App\Entity\Device\Device;
use App\Entity\MonitoringGroup\MonitoringGroup;
use App\Entity\Types\TypesOperator;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'alerts')]
#[ORM\Entity]
#[ORM\HasLifecycleCallbacks]
class Alert
{
    /**
     * @var int|null
     */
    #[ORM\Column(name: 'id', type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true, options: ['datatable_editable' => true])]
    public ?string $name = null;

    /**
     * @var AlertTargetType|null
     */
    #[ORM\ManyToOne(targetEntity: AlertTargetType::class, inversedBy: 'alerts')]
    #[ORM\JoinColumn(name: 'target_type')]
    public ?AlertTargetType $targetType = null;

    /**
     * @var AlertTargetSpec|null
     */
    #[ORM\ManyToOne(targetEntity: AlertTargetSpec::class, inversedBy: 'alerts')]
    #[ORM\JoinColumn(name: 'target_spec')]
    public ?AlertTargetSpec $targetSpec = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => 1])]
    public ?int $targetAmount = null;

    /**
     * @var Device|null
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'alerts')]
    #[ORM\JoinColumn(name: 'target_device_id', referencedColumnName: 'id_device')]
    public ?Device $targetDevice = null;

    /**
     * @var MonitoringGroup|null
     */
    #[ORM\ManyToOne(targetEntity: MonitoringGroup::class, inversedBy: 'alerts')]
    #[ORM\JoinColumn(name: 'target_mongrp_id', referencedColumnName: 'id')]
    public ?MonitoringGroup $targetMonitoringGroup = null;

    /**
     * @var int
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true, options: ['default' => 120])]
    public int $evaluateInterval = 120;

    /**
     * @var TypesOperator|null
     */
    #[ORM\ManyToOne(targetEntity: TypesOperator::class, inversedBy: 'alertsOperFirst')]
    #[ORM\JoinColumn(name: 'oper_first')]
    public ?TypesOperator $operFirst = null;

    /**
     * @var TypesOperator|null
     */
    #[ORM\ManyToOne(targetEntity: TypesOperator::class, inversedBy: 'alertsOperSecond')]
    #[ORM\JoinColumn(name: 'oper_second')]
    public ?TypesOperator $operSecond = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'num_first', type: Types::FLOAT, nullable: true)]
    public ?float $numFirst = null;

    /**
     * @var float|null
     */
    #[ORM\Column(name: 'num_second', type: Types::FLOAT, nullable: true)]
    public ?float $numSecond = null;

	#[ORM\Column(name: 'string_first', type: Types::STRING, length: 256, nullable: true)]
	public ?string $stringFirst = null;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'last_trigger_time ', type: Types::DATETIME_MUTABLE, options: ['default' => null])]
    public ?\DateTime $lastTriggerTime = null;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'last_notification_time ', type: Types::DATETIME_MUTABLE, options: ['default' => null])]
    public ?\DateTime $lastNotificationTime = null;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, nullable: false, options: ['default' => false, 'datatable_editable' => true])]
    public bool $enabled = false;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, nullable: false, options: ['default' => false])]
    public bool $active = false;

    /**
     * @var int
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => '0'])]
    public int $counter = 0;

    /**
     * @var int
     */
    #[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['default' => '0'])]
    public int $triggered = 0;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, nullable: false, options: ['default' => false])]
    public bool $deleted = false;

    /**
     * @var int
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public int $version;

    /**
     * Alert constructor
     */
    public function __construct()
    {
    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): ?string {

        return $this->name;

    }

    /**
     * @return AlertTargetType|null
     */
    public function getTargetType(): ?AlertTargetType {

        return $this->targetType;

    }

    public function setTargetType(AlertTargetType $targetType): void {

        $this->targetType = $targetType;

    }

    /**
     * @return AlertTargetSpec|null
     */
    public function getTargetSpec(): ?AlertTargetSpec {

        return $this->targetSpec;

    }

    public function setTargetSpec(AlertTargetSpec $targetSpec): void {

        $this->targetSpec = $targetSpec;

    }

    /**
     * @return int|null
     */
    public function getTargetAmount(): ?int {

        return $this->targetAmount;

    }

    public function setTargetAmount(int $amount): void {

        $this->targetAmount = $amount;

    }

    /**
     * @return \App\Entity\Device\Device|null
     */
    public function getTargetDevice(): ?Device {

        return $this->targetDevice;

    }

    /**
     * @param \App\Entity\Device\Device|null $device
     */
    public function setTargetDevice(?Device $device): void {

        $this->targetDevice = $device;

    }

    /**
     * @return MonitoringGroup|null
     */
    public function getTargetMonitoringGroup(): ?MonitoringGroup {

        return $this->targetMonitoringGroup;

    }

    /**
     * @param MonitoringGroup|null $monitoringGroup
     */
    public function setTargetMonitoringGroup(?MonitoringGroup $monitoringGroup): void {

        $this->targetMonitoringGroup = $monitoringGroup;

    }

    /**
     * @return TypesOperator|null
     */
    public function getOperFirst(): ?TypesOperator {

        return $this->operFirst;

    }

    public function setOperFirst(TypesOperator $operatorType): void {

        $this->operFirst = $operatorType;

    }

    /**
     * @return float|null
     */
    public function getNumFirst(): ?float {

        return $this->numFirst;

    }

    public function setNumFirst(float $number): void {

        $this->numFirst = $number;

    }

    /**
     * @return TypesOperator|null
     */
    public function getOperSecond(): ?TypesOperator {

        return $this->operSecond;

    }

    public function setOperSecond(TypesOperator $operatorType): void {

        $this->operSecond = $operatorType;

    }

    /**
     * @return float|null
     */
    public function getNumSecond(): ?float {

        return $this->numSecond;

    }

    public function setNumSecond(float $number): void {

        $this->numSecond = $number;

    }

	/**
	 * @return string|null
	 */
	public function getStringFirst(): ?string
	{
		return $this->stringFirst;
	}

	/**
	 * @param string|null $stringFirst
	 */
	public function setStringFirst(?string $stringFirst): void
	{
		$this->stringFirst = $stringFirst;
	}

    /**
     * @return bool
     */
    public function getEnabled(): bool {

        return $this->enabled;

    }

    public function setEnabled(bool $enabled): void {

        $this->enabled = $enabled;

    }

    /**
     * @return bool
     */
    public function getActive(): bool {

        return $this->active;

    }

    /**
     * @return bool
     */
    public function getDeleted(): bool {

        return $this->deleted;

    }

    /**
     * @param bool $enabled
     */
    public function setDeleted(bool $deleted): void {

        $this->deleted = $deleted;

    }

    /**
     * @return int
     */
    public function getVersion(): int {

        return $this->version;

    }

    public function setVersion(int $version): void {

        $this->version = $version;

    }

}