<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class LabelType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
	{

        $builder
            ->add('label', TextType::class, ['block_prefix' => 'modal_body'])
            ->add('save', SubmitType::class, ['label' => 'Add Label',
                'block_prefix' => 'modal_footer'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
	{

        $resolver->setDefaults([
           // 'data_class' => OsVersion::class,
        ]);

    }

}