<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class SystemLicenseApplyType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
	{

        $licenseFileName = $options['data']['licenseFileName'];
        $useForce = $options['data']['useForce'];

        $builder->add('file', HiddenType::class, ['data' => $licenseFileName]);
        $builder->add('useForce', HiddenType::class, ['data' => $useForce]);
        $builder->add('apply', SubmitType::class, ['label' => 'Process update']);

    }

}