<?php

namespace App\Service;

use App\Service\Api\FwUpload;
use Symfony\Component\HttpFoundation\File\Exception\FileException;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\String\Slugger\SluggerInterface;

class FileUploader
{
    /**
     * @param string $targetFwUploadDirectory
     * @param string $targetLicenseUploadDirectory
     * @param SluggerInterface $slugger
     * @param FwUpload $apiFwUploadService
     */
    public function __construct(
        private readonly string $targetFwUploadDirectory,
        private readonly string $targetLicenseUploadDirectory,
        private readonly SluggerInterface $slugger,
        private readonly FwUpload $apiFwUploadService
    ) {
    }

    /**
     * @param UploadedFile $file
     * @return string
     */
    public function uploadLicenseFile(UploadedFile $file): string
    {

        $originalFilename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $safeFilename = $this->slugger->slug($originalFilename);
        $fileName = $safeFilename . '-' . uniqid('', true) . '.' . $file->guessExtension();

        try {
            $file->move($this->targetLicenseUploadDirectory, $fileName);
        } catch (FileException $e) {
            throw $e;
        }

        return $fileName;
    }

    public function uploadFwFile(UploadedFile $file, int $fwId): array
    {

        $originalFilename = $file->getClientOriginalName();

        try {
            $file->move($this->targetFwUploadDirectory, $originalFilename);
            $message = $this->apiFwUploadService->uploadFwNotify($fwId, $originalFilename);
        } catch (FileException $e) {
            throw $e;
        }

        return [$message, $originalFilename];
    }
}
