<?php

namespace App\DataTable;

use Sg\DatatablesBundle\Datatable\Column\Column;
use Sg\DatatablesBundle\Datatable\Column\DateTimeColumn;
use Sg\DatatablesBundle\Datatable\Filter\DateRangeFilter;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;

/**
 * Class EventLogDatatable
 * @package App\Datatables
 */
class EventLogDatatable extends BaseDatatable
{

    protected string $entity = \App\Entity\EventLog\EventLog::class;
    protected string $name = 'event_log_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = array()): void
    {

        $eventTypes = $options['eventTypes'];

        parent::buildDatatable($options);

        $this->options->setOrder([0, 'desc']);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('eventType.name', Column::class, array(
                'title' => 'Type',
                'width' => '100%;',
                'searchable' => true,
                'orderable' => true,
                'filter' => array(SelectFilter::class, array(
                    'classes' => '',
                    'search_type' => 'eq',
                    'multiple' => false,
                    'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($eventTypes, 'name', 'name'),
                    'cancel_button' => true,
                ))
            ))
            ->add('value', Column::class, array(
                'title' => 'Value',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))
            ->add('msg', Column::class, array(
                'title' => 'Message',
                'default_content' => '',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))
			->add('user.email', Column::class, array(
				'title' => 'User',
				//'dql' => "CONCAT(user.firstName, ' ', user.lastName)",
				'default_content' => '',
				'width' => '100%;',
				'filter' => array(TextFilter::class,
					array(
						'cancel_button' => true,
					),
				),
			))
            ->add('time', DateTimeColumn::class, array(
                'title' => 'Created',
                'searchable' => true,
                'filter' => array(DateRangeFilter::class, array(
                    'cancel_button' => true,
                )),
                'date_format' => self::DATETIME_FORMAT,
            ))

        ;
    }

}