<?php

declare(strict_types=1);

namespace App\Entity\ConfigProfile;

use App\Entity\Device\Device;
use App\Entity\Device\DeviceOsVersion;
use App\Entity\Device\FwFileName;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'config_profiles')]
#[ORM\Entity]
class ConfigProfile
    {

	final public const ENTITY_TABLE_NAME = 'config_profiles';

    /**
	 *
     * @var int|null
     */
    #[ORM\Column(name: 'id', type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

	/**
	 * @var string|null
	 */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true, options: ['datatable_editable' => true])]
    public ?string $name;

	/**
	 * @var Device|null
	 */
    #[ORM\OneToOne(targetEntity: Device::class, inversedBy: 'configProfileAutomatic', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'automatic', referencedColumnName: 'id_device', nullable: true)]
    public ?Device $automatic;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, nullable: false, options: ['default' => false])]
    public bool $defaults;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, nullable: false, options: ['default' => true])]
    public bool $directive;

    /**
     * @var DeviceOsVersion
     */
    #[ORM\ManyToOne(targetEntity: DeviceOsVersion::class, inversedBy: 'configProfiles')]
    #[ORM\JoinColumn(name: 'os_version', referencedColumnName: 'id')]
    public DeviceOsVersion $osVersion;

    /**
     * @var FwFileName
     */
    #[ORM\ManyToOne(targetEntity: FwFileName::class, inversedBy: 'configProfiles')]
    #[ORM\JoinColumn(name: 'fwfname', referencedColumnName: 'id')]
    public FwFileName $fwfname;

	/**
	 * @var bool
	 */
	#[ORM\Column(type: Types::BOOLEAN, nullable: false, options: ['default' => false])]
	public bool $deleted;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: Device::class, mappedBy: 'configProfile', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
    public Collection $devices;

	/**
	 * @var Collection
	 */
	#[ORM\OneToMany(targetEntity: ConfigProfileKey::class, mappedBy: 'configProfile', cascade: ['persist'])]
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
	public Collection $configProfileKeys;

	#[ORM\OneToMany(targetEntity: ConfigProfileValue::class, mappedBy: 'profile', cascade: ['persist'])]
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
	public Collection $configProfiles;

    /**
     * ConfigProfile constructor
     */
    public function __construct(){

       $this->devices = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

	/**
	 * @return string|null
	 */
    public function getName(): ?string {

        return $this->name;

    }

	/**
	 * @param string|null $name
	 * @return void
	 */
	public function setName(?string $name): void
	{
		$this->name = $name;
	}

    /**
     * @return Device
     */
    public function getAutomatic(): ?Device {

        return $this->automatic;

    }

	/**
	 * @return bool
	 */
	public function isDeleted(): bool
	{
		return $this->deleted;
	}

	/**
	 * @param bool $deleted
	 */
	public function setDeleted(bool $deleted): void
	{
		$this->deleted = $deleted;
	}

	/**
	 * @return bool
	 */
	public function isDirective(): bool
	{
		return $this->directive;
	}

}