<?php

declare(strict_types=1);

namespace App\Entity\Tunnel;

use App\Entity\Tunnel;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'tunnel_status')]
#[ORM\Entity]
class TunnelStatus
{

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 32, unique: true, nullable: false)]
    public string $name;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 64, unique: true, nullable: false)]
    public string $description;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: Tunnel\Tunnels::class, mappedBy: 'status', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $tunnelStatuses;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: Tunnel\TunnelOperationStatusMapping::class, mappedBy: 'status', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $operationStatusMapping;

    /**
     * TunnelStatus constructor.
     */
    public function __construct() {

        $this->tunnelStatuses = new ArrayCollection();
        $this->operationStatusMapping = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

    /**
     * @return string
     */
    public function getDescription(): string {

        return $this->description;

    }

}