<?php

namespace App\EventSubscriber;

use App\Entity\EventLog\EventLog;
use App\Entity\EventLog\EventSource;
use App\Entity\EventLog\EventType;
use App\Event\WebTunnelEditEvent;
use App\Repository\EventSourceRepository;
use App\Repository\EventTypeRepository;
use App\Repository\TunnelWebRepository;
use Doctrine\ORM\EntityManagerInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class WebTunnelSubscriber implements EventSubscriberInterface
{
    /**
     * @var LoggerInterface
     */
    private LoggerInterface $logger;

    /**
     * @var EntityManagerInterface
     */
    private EntityManagerInterface $entityManager;

    /**
     * @var TunnelWebRepository
     */
    private TunnelWebRepository $tunnelWebRepository;

    /**
     * @var EventSourceRepository
     */
    private EventSourceRepository $eventSourceRepository;

    /**
     * @var EventTypeRepository
     */
    private EventTypeRepository $eventTypeRepository;

    /**
     * @param LoggerInterface $logger
     * @param EntityManagerInterface $entityManager
     * @param TunnelWebRepository $tunnelWebRepository
     * @param EventTypeRepository $eventTypeRepository
     * @param EventSourceRepository $eventSourceRepository
     */
    public function __construct(LoggerInterface $logger, EntityManagerInterface $entityManager,
                                TunnelWebRepository $tunnelWebRepository,
                                EventTypeRepository $eventTypeRepository,
                                EventSourceRepository $eventSourceRepository){

        $this->logger = $logger;
        $this->entityManager = $entityManager;
        $this->tunnelWebRepository = $tunnelWebRepository;
        $this->eventTypeRepository = $eventTypeRepository;
        $this->eventSourceRepository = $eventSourceRepository;

    }

    /**
     * @return array[]
     */
    public static function getSubscribedEvents(): array
	{

        return [
            WebTunnelEditEvent::NAME => ['onWebTunnelEditEvent', 10],
        ];

    }

    /**
     * @param WebTunnelEditEvent $event
     */
    public function onWebTunnelEditEvent(WebTunnelEditEvent $event): void
	{

        $this->logger->info('WebTunnel Subscriber says: Event posted this data {id}', [
            'id' => $event->getId(),
        ]);

        $this->entityManager->beginTransaction();

        $webTunnel = $this->tunnelWebRepository->findOneBy(['id' => $event->getId()]);
        $eventType = $this->eventTypeRepository->findOneBy(['name' => EventType::UI_TUNNEL_CFG_UPDATE_EVENT_TYPE_NAME]);
        $eventSource = $this->eventSourceRepository->findOneBy(['id' => EventSource::APP_WEBUI]);
        $eventLog = new EventLog();
        $eventLog->setEventType($eventType);
        $eventLog->setValue($webTunnel->getId());
        $eventLog->setSource($eventSource);

        $this->entityManager->persist($eventLog);
        $this->entityManager->flush();

        $this->entityManager->commit();

    }

}