<?php

namespace App\Controller\Admin\Help;

use App\Service\ConfigurationService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class HelpController extends Controller
{

    /**
     * @param $page
     * @return \Symfony\Component\HttpFoundation\Response
     */
    #[Route(path: 'admin/help/{page}', name: 'admin_help')]
    public function help(Request $request, $page, ConfigurationService $configurationService){

        $isFirstRun = null;

        if($page === 'welcome'){

            $isFirstRun = $configurationService->isFirstRun();
            $configurationService->updateIsFirstRun(false);

        }

        return $this->render('help/'. $page .'.html.twig', ['isFirstRun' => $isFirstRun]);

    }

}