<?php

namespace App\Controller\Admin\System;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\Datatables\UserDatatable;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Datatable\DatatableInterface;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Response;

class UserManagementController extends BaseController
{
    /**
     * @return \Symfony\Component\HttpFoundation\JsonResponse|Response
     * @throws \Exception
     */
    #[Route(path: '/admin/user-management', name: 'admin_user_management')]
    public function default(Request $request, DatatableFactory $factory,
                            DatatableResponse $responseService)
    {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        /** @var DatatableInterface $datatable */
        $datatable = $factory->create(UserDatatable::class);
        $datatable->buildDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        return $this->render("system/userManagement.html.twig", [
            'datatable' => $datatable,
            'filter' => $this->filter,
        ]);

    }

    /**
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    #[Route(path: '/admin/user-add', name: 'admin_user_add')]
    public function addUser(Request $request)
    {

        return $this->redirectToRoute('admin_user_management');

    }

}