<?php

namespace App\Controller\Admin\Tunnel;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\Datatables\TunnelWebDatatable;
use App\Entity\TunnelOperation;
use App\Entity\TunnelStatus;
use App\Repository\TunnelWebRepository;
use App\Service\ConfigurationService;
use Doctrine\Persistence\ManagerRegistry;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Response;
use Sg\DatatablesBundle\Datatable\DatatableInterface;

class TunnelController extends BaseController
{

    /**
     * @return \Symfony\Component\HttpFoundation\JsonResponse|Response
     * @throws \Exception
     */
    #[Route(path: 'admin/tunnel/web', name: 'admin_tunnel_web')]
    public function webTunnel(Request $request, ManagerRegistry $managerRegistry,
                              DatatableFactory $factory, DatatableResponse $responseService)
    {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $tunnelStatuses = $managerRegistry->getRepository(TunnelStatus::class)->findAll();
        $tunnelOperations = $managerRegistry->getRepository(TunnelOperation::class)->findAll();

        /** @var DatatableInterface $datatable */
        $datatable = $factory->create(TunnelWebDatatable::class);
        $datatable->buildDatatable(['tunnelStatuses' => $tunnelStatuses, 'tunnelOperations' => $tunnelOperations]);

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        return $this->render('tunnel/web-index.html.twig', ['datatable' => $datatable, 'filter' => $this->filter]);

    }

    /**
     * @param $webTunnelId
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     * @throws \Exception
     */
    #[Route(path: 'admin/tunnel/web/connect/{webTunnelId}', name: 'admin_tunnel_web_connect')]
    public function webTunnelDeviceUrl(Request $request, $webTunnelId, ConfigurationService $configurationService,
                                       TunnelWebRepository $tunnelWebRepository ){

        $webTunnel = $tunnelWebRepository->findOneBy(['id' => $webTunnelId]);

        if(!$webTunnel){

            throw new \Exception('No tunnel found.');

        }

        $webTunnelUrl = $configurationService->getWebTunnelUrl();

        $connectUrl = 'https://' . $request->getHost() . '/' . $webTunnelUrl . '/' . $webTunnel->getUrl() . '/';

        return $this->redirect($connectUrl);

    }

}