<?php

declare(strict_types=1);

namespace App\Entity\Alert;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'alert_target_type')]
#[ORM\Entity]
class AlertTargetType implements \Stringable
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false, unique: true)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: \App\Entity\Alert\Alert::class, mappedBy: 'targetType', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'target_type')]
    public Collection $alerts;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: \App\Entity\Alert\AlertTargetMap::class, mappedBy: 'targetType', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $targetMaps;

    /**
     * AlertTargetType constructor
     */
    public function __construct() {

        $this->alerts = new ArrayCollection();
        $this->targetMaps = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string{

        return $this->name;

    }

    /**
     * @return Collection
     */
    public function getAlerts(): Collection {

        return $this->alerts;

    }

    /**
     * @return Collection
     */
    public function getTargetMaps(): Collection {

        return $this->targetMaps;

    }

    /**
     * @return string
     */
    public function __toString(): string {

        return $this->name;

    }

}