#!/bin/bash

echo "This script allows to rename some of the GUI columns to custom names. You have to run it under root and take care of what string you specify as the edge case is breaking your GUI and needing to ask for support or disabling the broken columns."

echo -e "\nInitializing..."

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
FUNCS="deploy_funcs.sh"

. "$DIR"/"$FUNCS" || {
	echo "Unable to read deploy functions, exiting..." >&2
	exit 1
}

BASEDEFS="base_defs"

read_defs || {
	echo "Unable to read configuration, is application installed?" >&2
	exit 1
}

targetdir="$GUIDIR/translations"
targetfile="messages.en.xlf"
workfile="messages_workfile.xlf"
backupfile="messages_firstbackup.xlf"
columns=( "Note1" "Note2" "Note3" )
done=0

update_column() {
	[ $# -eq 2 ] || return 1
	pattern="$1"
	replacement="$2"
	[ -z "$replacement" ] && {
		echo "Skipping $pattern as the new pattern is empty."
		return 0
	}
	if echo "$replacement" | grep '"' >/dev/null; then
		echo "String for $pattern column contains quotes (not allowed, skipping column)."
		return 1
	fi
	echo "Replacing column $pattern value with new value '$replacement'"
	tmpfile="$(mktemp)"
	cat "$workfile" | xmlstarlet edit --update "//_:file/_:unit[@name=\"$pattern\"]/_:segment/_:target" -v "$replacement" "$workfile" | xmlstarlet unescape >$tmpfile || {
		rm -f "$tmpfile"
		fail_fat "Failed to update file for the $column column."
	}
	mv "$tmpfile" "$workfile" || fail_fat "Unable to write to workfile '$workfile'"
	return 0
}

cd "$targetdir" || fail_fat "Unable to change directory to '$targetdir'"
cp "$targetfile" "$workfile" || fail_fat "Unable to write to '$workfile'"
[ -f "$backupfile" ] || {
	echo "Backup file not detected, supposing first use and creating backup file..."
	cp "$targetfile" "$backupfile" || fail_fat "Unable to create backupfile '$backupfile'"
}
echo -e "\nEnter names customized names for columns ${columns[@]} below. Empty string means keep it as it is.\n"
for i in ${columns[@]} ; do 
	echo "$i:"
	read -r value
	[ -z "$value" ] || if update_column "$i" "$value"; then done=$((done+1)); fi
done
cp "$workfile" "$targetfile" || fail_fat "Unable to update '$targetfile'"
echo "Updated: $done columns."
echo "Cleaning up GUI web cache..."
if php $BINDIR/web/gui/bin/console cache:clear; then
	echo "Success"
else
	echo "Failed to clear cache, you may remove the $SRVDIR/var/cache/prod/ manually to enforce column names reload on GUI."
fi
