<?php

declare(strict_types=1);

namespace App\Controller\Admin\System;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\DataTable\UserDatatable;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Datatable\DatatableInterface;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\Response;

class UserManagementController extends BaseController
{
	/**
	 * @param Request $request
	 * @param DatatableFactory $factory
	 * @param DatatableResponse $responseService
	 * @return JsonResponse|Response
	 * @throws \Exception
	 */
    #[Route(path: '/admin/user-management', name: 'admin_user_management')]
    public function default(Request $request, DatatableFactory $factory,
                            DatatableResponse $responseService): JsonResponse|Response
	{

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        /** @var DatatableInterface $datatable */
        $datatable = $factory->create(UserDatatable::class);
        $datatable->buildDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        return $this->render("system/userManagement.html.twig", [
            'datatable' => $datatable,
            'filter' => $this->filter,
        ]);

    }

	/**
	 * @param Request $request
	 * @return RedirectResponse
	 */
    #[Route(path: '/admin/user-add', name: 'admin_user_add')]
    public function addUser(Request $request): RedirectResponse
	{

        return $this->redirectToRoute('admin_user_management');

    }

}