<?php

namespace App\DataTable;

use App\Entity\User\User;
use Sg\DatatablesBundle\Datatable\Column\BooleanColumn;
use Sg\DatatablesBundle\Datatable\Column\Column;
use Sg\DatatablesBundle\Datatable\Column\DateTimeColumn;
use Sg\DatatablesBundle\Datatable\Editable\SelectEditable;
use Sg\DatatablesBundle\Datatable\Editable\TextEditable;
use Sg\DatatablesBundle\Datatable\Filter\DateRangeFilter;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;

/**
 * Class UserDatatable
 * @package App\Datatables
 */
class UserDatatable extends BaseDatatable
{

    protected string $entity = User::class;
    protected string $name = 'user_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = array()): void
    {

        parent::buildDatatable($options);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    /*array(
                        //'link' => 'test',
                        'action' => array(
                            'template' => '/datatable/user/addUser.js.twig',
                            'vars' => array('link' =>  $this->router->generate('admin_user_add')),

                        ),
                        'class_name' => 'btn-primary',
                        'name' => 'addUser',
                        'text' => 'Add User',
                    ),*/
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('firstName', Column::class, array(
                'title' => 'User Name',
                'dql' => "CONCAT(user.firstName, ' ', user.lastName)",
                'width' => '100%;',
                'searchable' => true,
                'orderable' => true,
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))
            ->add('email', Column::class, array(
                'title' => 'Email',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
                'editable' => array(TextEditable::class,
                    array(
                        'url' => 'app_datatables_edit',
                        'placeholder' => 'Edit value',
                        'empty_text' => 'None',
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                                if (true === $this->isSuperAdmin() || $this->getUser()->getId() === $row['id']) {
                                    return true;
                                };
                            }

                            return false;
                        },
                        'mode' => 'inline',
                    ),
                ),
            ))
            ->add('roles', Column::class, array(
                'title' => 'Roles',
                'default_content' => '',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))
            ->add('lastLogin', DateTimeColumn::class, array(
                'title' => 'Last login',
                'searchable' => true,
                'filter' => array(DateRangeFilter::class, array(
                    'cancel_button' => true,
                )),
                'date_format' => self::DATETIME_FORMAT,
            ))
            ->add('active', BooleanColumn::class, array(
                'title' => 'Active',
                'width' => '100%;',
                'true_label' => 'Active',
                'false_label' => 'Inactive',
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array(
                            '' => 'Any',
                            '1' => 'Active',
                            '0' => 'Inactive',
                        ),
                        'cancel_button' => true,
                    )
                ),
                'editable' => array(SelectEditable::class,
                    array(
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                                if (true === $this->isSuperAdmin() && $this->getUser()->getId() !== $row['id']) {
                                    return true;
                                };
                            }
                            return false;
                        },
                        'source' => array(
                            array('value' => 1, 'text' => 'Active'),
                            array('value' => 0, 'text' => 'Inactive'),
                        ),
                        'mode' => 'inline',
                        'empty_text' => '',
                    ),
                ),
            ))

        ;
    }

}