<?php

namespace App\EventSubscriber;

use App\Entity\CustomScript\CustomScript;
use App\Event\CustomScriptCreateEvent;
use App\Event\CustomScriptEditEvent;
use App\Service\Api\DataSync;
use Doctrine\ORM\EntityManagerInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CustomScriptSubscriber implements EventSubscriberInterface
{
    private LoggerInterface $logger;
    private DataSync $dataSyncApi;
    private EntityManagerInterface $entityManager;

    public function __construct(LoggerInterface $logger, DataSync $dataSyncApi,
                                EntityManagerInterface $entityManager,)
    {
        $this->logger = $logger;
        $this->dataSyncApi = $dataSyncApi;
        $this->entityManager = $entityManager;

    }

    public static function getSubscribedEvents(): array
    {
        return [
            CustomScriptCreateEvent::NAME => ['onCustomScriptCreateEvent', 10],
            CustomScriptEditEvent::NAME => ['onCustomScriptEditEvent', 20]
        ];
    }

    public function onCustomScriptCreateEvent(CustomScriptCreateEvent $event): void
    {

        $this->logger->info('Custom script Subscriber: Event create id:{id}', [
            'id' => $event->getId(),
        ]);

        $this->dataSyncApi->syncCallByTableName(DataSync::CUSTOM_SCRIPT_TABLE_NAME_ID);
        $this->dataSyncApi->syncCallByTableName(DataSync::CUSTOM_SCRIPT_AGENT_PROFILE_MAP_TABLE_NAME_ID);
        $this->dataSyncApi->syncCallByTableName(DataSync::CUSTOM_SCRIPT_DEV_TYPE_MAP_TABLE_NAME_ID);

    }

    public function onCustomScriptEditEvent(CustomScriptEditEvent $event): void
    {

        $this->logger->info('CustomScript Subscriber says: Event posted this data {id}', [
            'id' => $event->getId(),
        ]);

        $this->entityManager->beginTransaction();

        $customScript = $this->entityManager->getRepository(CustomScript::class)->findOneBy(['id' => $event->getId()]);

        if($customScript){

            $customScript->setVersion($customScript->getVersion() + 1);
            $this->entityManager->persist($customScript);
            $this->entityManager->flush();
            $this->entityManager->commit();

            $this->dataSyncApi->syncCallByTableName(DataSync::CUSTOM_SCRIPT_TABLE_NAME_ID);
            $this->dataSyncApi->syncCallByTableName(DataSync::CUSTOM_SCRIPT_AGENT_PROFILE_MAP_TABLE_NAME_ID);
            $this->dataSyncApi->syncCallByTableName(DataSync::CUSTOM_SCRIPT_DEV_TYPE_MAP_TABLE_NAME_ID);

        }else{

            $this->entityManager->rollback();

        }



    }

}