<?php

namespace App\DataTable;

use App\DataTable\Column\CustomSecretDataColumn;
use App\Entity\Tool\AuthProfile;
use App\Entity\Tool\SmsHistory;
use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Column\DateTimeColumn;
use Sg\DatatablesBundle\Datatable\Column\LinkColumn;
use Sg\DatatablesBundle\Datatable\Editable\TextEditable;
use Sg\DatatablesBundle\Datatable\Filter\DateRangeFilter;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;
use App\Bundles\Sg\DatatablesBundle\Datatable\Filter\CustomSelectFilter;
use Sg\DatatablesBundle\Datatable\Column\Column;

/**
 * Class AuthManagementDatatable
 * @package App\Datatables
 */
class SmsHistoryDatatable extends BaseDatatable
{

    protected string $entity = SmsHistory::class;
    protected string $name = 'sms_history_datatable';

    /**
     * @param array $options
     * @throws \Exception
     */
    public function buildDatatable(array $options = array()): void
    {

        parent::buildDatatable($options);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    array(
                        'action' => array(
                            'template' => '/datatable/tool/sendSms.js.twig',
                            'vars' => array('link' =>  $this->router->generate('admin_tool_sms_sender_send')),
                        ),
                        'class_name' => 'btn-add',
                        'name' => 'addAuthProfile',
                        'text' => '<i class=\"fa fa-message\"></i> Send SMS',
                    ),
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder

            ->add('smsTemplate.label', Column::class, array(
                'title' => 'Sms',
                'width' => '100%;',
                'class_name' => '',
                'searchable' => false,
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))

            ->add('customText', Column::class,[
                'title' => 'Text',
                'width' => '100%;',
                'filter' => [
                    TextFilter::class,[
                        'cancel_button' => true,
                    ],
                ],
            ])

            ->add('sent', DateTimeColumn::class, array(
                'title' => 'Sent',
                'default_content' => 'Never',
                'width' => '100%;',
                'date_format' => self::DATETIME_FORMAT,
                'filter' => array(DateRangeFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))

            ->add(
                'device.devId',
                LinkColumn::class,
                [
                    'title' => 'Sent from',
                    'default_content' => '',
                    'width' => '100%;',
                    'route' => 'admin_devices_detail',
                    'route_params' => function ($row) {
                        return [
                            'deviceId' => $row['device']['id'],
                        ];
                    },
                    /*'filter' => [
                        SelectFilter::class,[
                            'search_type' => 'eq',
                            'select_options' => ['' => 'Any']
                                + $this->getOptionsFromArray($this->devices, 'devid', 'devid'),
                            'cancel_button' => true,
                        ],
                    ],*/
                ]
            )

            ->add('destination', Column::class,[
                'title' => 'Destination',
                'width' => '100%;',
                'filter' => [
                    TextFilter::class,[
                        'cancel_button' => true,
                    ],
                ],
            ])

        ;
    }

}