<?php

namespace App\DataTable;

use App\Entity\Label\SystemLabel;
use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Column\Column;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;

/**
 * Class LabelDatatable
 * @package App\Datatables
 */
class SystemLabelDatatable extends BaseDatatable
{

    protected string $entity = SystemLabel::class;
    protected string $name = 'system_labels_datatable';

    /**
     * @param array $options
     * @throws \Exception
     */
    public function buildDatatable(array $options = array()): void
    {

        parent::buildDatatable($options);

        $this->extensions->set([
            'buttons' => [
                'create_buttons' => [ // custom buttons
                    $this->getRefreshButton()
                ],
            ]
        ]);

        $this->addIdColumn();

        $this->columnBuilder
            ->add('label', Column::class, [
                'title' => 'Label',
                'width' => '40%;',
                'filter' => [
                    TextFilter::class,
                    [
                        'cancel_button' => true,
                    ],
                ],
            ])
            ->add('description', Column::class, [
                'title' => 'Label',
                'width' => '100%;',
                'filter' => [
                    TextFilter::class,
                    [
                        'cancel_button' => true,
                    ],
                ],
            ])
            ->add('Devices_count', Column::class, [
                'title' => 'Devices count',
                'width' => '100%;',
                'class_name' => 'row_devices_label_count',
                'dql' => '(SELECT COUNT({p}) FROM App\Entity\Label\SystemLabelDeviceMap {p} WHERE {p}.systemLabel = systemlabel.id)',
                'searchable' => true,
                'orderable' => true,
            ])
            ->add(null, ActionColumn::class, array(
                'title' => $this->translator->trans('sg.datatables.actions.title'),
                'width' => '100%;',
                'actions' => [
                    [
                        'route' => 'admin_devices',
                        'route_parameters' => function($row){
                            return ['column[System Labels]' => trim(urldecode(strip_tags($row['label'])))];
                        },
                        'label' => $this->translator->trans('sg.datatables.actions.list'),
                        'icon' => self::ICON_DETAIL,
                        'attributes' => [
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.list'),
                            'class' => 'btn btn-primary btn-xs mb-1 mr-sm-2',
                            'role' => 'button',
                        ],
                        'start_html' => '<div class="input-group">',
                        'render_if' => function ($row) {
                            return $row['Devices_count'] > 0 && $this->authorizationChecker->isGranted('ROLE_ADMIN');
                        },

                    ],

                ],
            ))
        ;
    }

}