<?php

declare(strict_types=1);

namespace App\Entity\EventLog;

use App\Entity\User\User;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'log_events')]
#[ORM\Entity]
class EventLog
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var EventType
     */
    #[ORM\ManyToOne(targetEntity: EventType::class, inversedBy: 'events')]
    #[ORM\JoinColumn(name: 'evtype')]
    public EventType $eventType;

    /**
     * @var int
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public int $value;

    #[ORM\ManyToOne(targetEntity: EventSource::class, inversedBy: 'events')]
    #[ORM\JoinColumn(name: 'source')]
    public EventSource $source;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $extraId = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: false)]
    public ?string $msg = null;

	#[ORM\ManyToOne(targetEntity: User::class, inversedBy: 'events')]
	#[ORM\JoinColumn(name: 'user_id')]
	public User $user;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'time', type: Types::DATETIME_MUTABLE, options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $time;

    /**
     * EventLog constructor.
     */
    public function __construct()
    {
        $this->time = new \DateTime();
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return EventType
     */
    public function getEventType(): EventType
    {
        return $this->eventType;
    }

    public function setEventType(EventType $eventType): void
    {
        $this->eventType = $eventType;
    }

    /**
     * @return int
     */
    public function getValue(): int
    {
        return $this->value;
    }

    public function setValue(int $value): void
    {
        $this->value = $value;
    }

    /**
     * @return EventSource
     */
    public function getSource(): EventSource
    {
        return $this->source;
    }

    public function setSource(EventSource $source): void
    {
        $this->source = $source;
    }

    /**
     * @return int|null
     */
    public function getExtraId(): ?int
    {
        return $this->extraId;
    }

    public function setExtraId(?int $extraId): void
    {
        $this->extraId = $extraId;
    }

    /**
     * @return string|null
     */
    public function getMsg(): ?string
    {
        return $this->msg;
    }

    public function setMsg(?string $msg): void
    {
        $this->msg = $msg;
    }

	/**
	 * @return string|null
	 */
	/**
	 * @return User
	 */
	public function getUser(): User
	{
		return $this->user;
	}

	/**
	 * @param string|null $userId
	 */
	/**
	 * @param User $user
	 */
	public function setUser(User $user): void
	{
		$this->user = $user;
	}
}
