<?php

declare(strict_types=1);

namespace App\Entity\Tool;

use App\Entity\Device\Device;
use App\Repository\SimCardRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

#[ORM\Table(name: 'sim_cards')]
#[ORM\Entity(repositoryClass: SimCardRepository::class)]
#[UniqueEntity('msisdn')]
class SimCard
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 32, unique: true, nullable: false)]
    public string $iccid;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 32, unique:true, nullable: true)]
    public ?string $msisdn = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $label = null;

    /**
     * @var Device|null
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'deviceSimCards')]
    #[ORM\JoinColumn(name: 'device_user', referencedColumnName: 'id_device')]
    public Device|null $deviceUser = null;

    /**
     * @var Device|null
     */
    #[ORM\ManyToOne(targetEntity: Device::class, inversedBy: 'deviceLastSeen')]
    #[ORM\JoinColumn(name: 'device_last_seen', referencedColumnName: 'id_device')]
    public Device|null $deviceLastSeen = null;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getIccid(): string
    {
        return $this->iccid;
    }

    /**
     * @param string $iccid
     */
    public function setIccid(string $iccid): void
    {
        $this->iccid = $iccid;
    }

    /**
     * @return string|null
     */
    public function getMsisdn(): ?string
    {
        return $this->msisdn;
    }

    /**
     * @param string|null $msisdn
     */
    public function setMsisdn(?string $msisdn): void
    {
        $this->msisdn = $msisdn;
    }

    /**
     * @return string|null
     */
    public function getLabel(): ?string {

        return $this->label;

    }

    /**
     * @param string|null $label
     */
    public function setLabel(?string $label): void
    {
        $this->label = $label;
    }

    /**
     * @return Device|null
     */
    public function getDeviceUser(): ?Device
    {
        return $this->deviceUser;
    }

    /**
     * @param Device|null $deviceUser
     */
    public function setDeviceUser(?Device $deviceUser): void
    {
        $this->deviceUser = $deviceUser;
    }

}