<?php

namespace App\EventSubscriber;

use App\Entity\EventLog\EventType;
use App\Event\ButtonTypeEventLogEvent;
use App\Repository\EventLogRepository;
use Psr\Log\LoggerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

readonly class EventLogSubscriber implements EventSubscriberInterface
{

	/**
	 * @param LoggerInterface $logger
	 * @param EventLogRepository $eventLogRepository
	 */
    public function __construct(private LoggerInterface $logger, private EventLogRepository $eventLogRepository)
    {

    }

    /**
     * @return array[]
     */
    public static function getSubscribedEvents(): array {
        return [
            ButtonTypeEventLogEvent::NAME => ['onButtonTypeEventLogEvent', 10],
        ];
    }

    public function onButtonTypeEventLogEvent(ButtonTypeEventLogEvent $event): void
	{

		try{

			$eventLog = $this->eventLogRepository->addEventLog(
				EventType::UI_BUTTON_EVENT_TYPE_NAME, $event->getUser(), $event->getButtonId(), $event->getMessage()
			);

			$this->eventLogRepository->persist($eventLog);

		}catch (\Exception $e){

			$this->logger->error('ButtonEventLogMessage cannot be saved to EventLog, user:' .
				$event->getUser() . ', ButtonId:' . $event->getButtonId() . ', message:' . $event->getMessage() . ', error:' . $e->getMessage(),
				['EventLogHandler']);

		}

	}

}