<?php

namespace App\Repository;

use App\Entity\Tunnel\TunnelOperation;
use App\Entity\Tunnel\Tunnels;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\DBAL\Exception;
use Doctrine\DBAL\Result;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Tunnels|null find($id, $lockMode = null, $lockVersion = null)
 * @method Tunnels|null findOneBy(array $criteria, array $orderBy = null)
 * @method Tunnels[]    findAll()
 * @method Tunnels[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TunnelWebRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Tunnels::class);
    }

    /**
     * @param int $tunnelId
     * @param string $operationName
     * @return bool
     */
    public function processRequestOperation(int $tunnelId, string $operationName): bool {

        $tunnel = $this->findOneBy(['id' => $tunnelId]);

        if ($tunnel) {

            $entityManager = $this->getEntityManager();
            $operation = $entityManager->getRepository(TunnelOperation::class)
                ->findOneBy(['name' => $operationName]);
            $tunnel->setRequestedOperation($operation);
            $entityManager->persist($tunnel);
            $entityManager->flush();

            return true;

        }

        return false;

    }

    /**
     * @throws Exception
     */
    public function cleanup(): Result
    {

        $sql = sprintf('TRUNCATE TABLE tunnels');
        return $this->getEntityManager()->getConnection()->executeQuery($sql);

    }

}
