var Encore = require('@symfony/webpack-encore');
const WorkboxPlugin = require('workbox-webpack-plugin');
const CompressionPlugin = require("compression-webpack-plugin");
const zlib = require("zlib");
const FosRouting = require('fos-router/webpack/FosRouting');

// Set the runtime environment
Encore.configureRuntimeEnvironment('prod');

Encore
    .setOutputPath('public/assets') // the project directory where all compiled assets will be stored
    .setPublicPath('/assets') // the public path used by the web server to access the previous directory

    .addEntry('appJquery', './assets/js/appJquery.js') // will create public/build/app.js and public/build/app.css
    //.addEntry('appVue', './assets/js/appVue.js') // will create public/build/app.js and public/build/app.css
    .addEntry('app', './assets/js/app.js')
    //.addEntry('sw', './assets/js/service-worker.js')
    .enableVueLoader()
    // When enabled, Webpack "splits" your files into smaller pieces for greater optimization.
    //.splitEntryChunks()

    // will require an extra script tag for runtime.js
    // but, you probably want this, unless you're building a single-page app
    .enableSingleRuntimeChunk()
    //.disableSingleRuntimeChunk()

    /*
     * FEATURE CONFIG
     *
     * Enable & configure other features below. For a full
     * list of features, see:
     * https://symfony.com/doc/current/frontend.html#adding-more-features
     */
    .cleanupOutputBeforeBuild() // empty the outputPath dir before each build
    .enableBuildNotifications() // show OS notifications when builds finish/fail
    .enableSourceMaps(!Encore.isProduction())
    // enables hashed filenames (e.g. app.abc123.css)
    .enableVersioning(Encore.isProduction())

    //.enableSassLoader() // allow sass/scss files to be processed
    //.enableSourceMaps(!Encore.isProduction())

    // enables Sass/SCSS support
    .enableSassLoader()
    .enablePostCssLoader()

    .copyFiles({
        from: './assets/images',
        to: 'images/[path][name].[hash:8].[ext]'
    })

    // uncomment if you use TypeScript
    //.enableTypeScriptLoader()

    // uncomment to get integrity="..." attributes on your script & link tags
    // requires WebpackEncoreBundle 1.4 or higher
    //.enableIntegrityHashes()

    .addExternals({
        jQuery: 'jQuery' //toto funguje jako externi jquery
    })
    // uncomment if you're having problems with a jQuery plugin
    .autoProvidejQuery()

    .autoProvideVariables({
        $: 'jquery',
        jQuery: 'jquery',
        'window.jQuery': 'jquery',
        Popper: ['popper.js', 'default']
    })
    .addPlugin(new FosRouting())
    .addPlugin(
      new WorkboxPlugin.GenerateSW({
        swDest: 'service-worker.js',
        clientsClaim: true,
        skipWaiting: true,
        // Do not precache images
        exclude: [/\.(?:png|jpg|jpeg|svg|webp)$/],

        // Define runtime caching rules.
        runtimeCaching: [{
          // Match any request that ends with .png, .jpg, .jpeg, .svg or webp
          urlPattern: /\.(?:png|jpg|jpeg|svg|webp)$/,

          // Apply a cache-first strategy.
          handler: 'CacheFirst',

          options: {
            // Use a custom cache name.
            cacheName: 'images',

            // Only cache 10 images.
            expiration: {
              maxEntries: 20,
            },
          },
        }],
      })
    )
    .addPlugin(
        new CompressionPlugin({
            filename: "[path][base].gz",
            algorithm: "gzip",
            test: /\.js$|\.css$|\.html$/,
            threshold: 10240,
            minRatio: 0.8,
        }),
    )
    .addPlugin(
        new CompressionPlugin({
            filename: "[path][base].br",
            algorithm: "brotliCompress",
            test: /\.(js|css|html|svg)$/,
            compressionOptions: {
                params: {
                    [zlib.constants.BROTLI_PARAM_QUALITY]: 11,
                },
            },
            threshold: 10240,
            minRatio: 0.8,
            deleteOriginalAssets: false,
        }),
    )
    /*.addPlugin(     
        new SWPrecacheWebpackPlugin(    //deprecated
        {
            cacheId: 'Symfonator',
            dontCacheBustUrlsMatching: /\.\w{8}\./,
            filename: 'service-worker.js',             
            minify: true,
            navigateFallback: 'index.html',
            staticFileGlobsIgnorePatterns: [/\.map$/, /asset-manifest\.json$/],
        })
    )*/
;

/*
var config = Encore.getWebpackConfig();

// disable amd, for datatable
config.module.rules.unshift({
    parser: {
        amd: false
    }
});

module.exports = config;
 */

// export the final configuration
module.exports = Encore.getWebpackConfig();